ORCA/M Asm65816 2.1.0

0001 8547                       title 'PopUpDefProc' 
0002 8547              **********************************************************************
0003 8547              *
0004 8547              * PopUp Control Def Proc
0005 8547              *
0006 8547              *
0007 8547              * Copyright Apple Computer, Inc. 1988-92
0008 8547              * All Rights Reserved
0009 8547              *
0010 8547              * 26 Oct 88         Harry Yee
0011 8547              *
0012 8547              * Finished initial coding for pop-ups
0013 8547              *
0014 8547              * 18 Nov 88         Harry Yee
0015 8547              *
0016 8547              * Finished resource support for pop-ups.
0017 8547              *
0018 8547              * 21 Nov 88         Harry Yee
0019 8547              *
0020 8547              * Changed do_track so that the x register upon exit, contains the part code
0021 8547              * if mouse was in pop-up when released, if mouse was outside menu then x
0022 8547              * contains zero. This needed to be changed because we were always getting a hit
0023 8547              * even though the user would drag the mouse outside the pop-up and then release.
0024 8547              * TRACKCONTROL also being changed to take advantage of this.
0025 8547              *
0026 8547              * 23 Nov 88         Harry Yee
0027 8547              *
0028 8547              * The control manager call MoveControl changed the pop-up control's main ctlRect,
0029 8547              * but since the pop-up box's rect was stored internally it needed to be changed also.
0030 8547              * I now change the moveCtl routine from a do nothing routine to change the pop-up box's
0031 8547              * rect.
0032 8547              *
0033 8547              * I now check the control's invisible bit before drawing the control.
0034 8547              *
0035 8547              * FRightJustifyResult is now implemented. Changed routine DrawPopUp to make it work.
0036 8547              *
0037 8547              * Bit 5 of the control's flag is now defined. If set the pop-up title will not be highlighted
0038 8547              * when the pop-up is selected.
0039 8547              *
0040 8547              * 01 Dec 88         Harry Yee
0041 8547              *
0042 8547              * The pop-up's title is now also part of the pop-up control's "hot spot".
0043 8547              *
0044 8547              * Pop-ups now work for an invalid initial value (BRC #38521, #38520)
0045 8547              *
0046 8547              * In do_init I now check the pcount, if it is 9 then use default color table (which I now
0047 8547              * define, I use to get this from the current menu bar's control record and I use do get in
0048 8547              * the do_draw routine), if the pcount is 10 then then I use the ptr to the colorTable passed
0049 8547              * by the app.
0050 8547              *
0051 8547              * 12 Dec 88         Harry Yee
0052 8547              *
0053 8547              * Fix problem with drawing pop-ups in color.
0054 8547              *
0055 8547              * 15 Dec 88         Harry Yee
0056 8547              *
0057 8547              * Bit 6 of the control's flag is now defined. If set the pop-up, when selected will be
0058 8547              * drawn with white space if the whole pop-up cannot fit in the port and there is
0059 8547              * room to add the white space to the pop-up.
0060 8547              *
0061 8547              * Added do_key routine (#13) for handling command key equivalents in pop-ups.
0062 8547              *
0063 8547              * 04 Jan 89         Harry Yee
0064 8547              *
0065 8547              * Fixed minor problem in do_test. The rectangle we were checking is a bit too large
0066 8547              * because it was fudged in do_init to make things work correctly in the menu manager call
0067 8547              * HiliteMenu. It was unfudged before making the check.
0068 8547              *
0069 8547              * 30 Jan 89         Harry Yee
0070 8547              *
0071 8547              * Whenever a NewValue defproc message got sent I would just call do_draw. This caused problems
0072 8547              * because the ctlParam input was different for each call. I now have a separate defproc to handle
0073 8547              * the NewValue message.
0074 8547              *
0075 8547              * When the pop-up's title got hilited I hilited too much in 640 mode and not enough in 320 mode.
0076 8547              * The above problem also arose when switching from one mode to another. _HiliteMenu has
0077 8547              * been changed to fix this problem. BRC #40712.
0078 8547              *
0079 8547              * 07 Feb 89         Harry Yee
0080 8547              *
0081 8547              * In do_init if there is no color table specified then zero is stored in the ctlColor field
0082 8547              * to specify that the default color table should be used. The GetColor routine in the
0083 8547              * menu manager has been changed to special case for ctlColor being zero. This change was necesary
0084 8547              * because when the menu manager was actually loaded into RAM i.e. old ROM, 4.1 system disk,
0085 8547              * a SetBarColors would really fuck up the pop-up control's default color table.
0086 8547              *
0087 8547              * 15 Mar 89         Harry Yee
0088 8547              *
0089 8547              * Did away with DrawPopUp call so lots of things changed. This makes the pop-up
0090 8547              * code much easier to maintain (now we don't have to go through menu manager, except
0091 8547              * for drawing the title)
0092 8547              *
0093 8547              * Fixed several bugs:
0094 8547              *  ForeGround color was being changed but never restored. BRC #45534.
0095 8547              *  If title was apple logo, title width was not getting set right. BRC #45146
0096 8547              *  If there was no selection in the pop-up rect the ctlValue did not reflect
0097 8547              *  this. If there is no selection, GetCtlValue will return zero. BRC #45143.
0098 8547              *
0099 8547              * 16 Mar 89         Harry Yee
0100 8547              *
0101 8547              * Changed new_value routine. Didn't need to actually store the new control value
0102 8547              * myself because the control manager already does this for us.
0103 8547              *
0104 8547              * 23 Mar 89         Harry Yee
0105 8547              *
0106 8547              * Fixed problem with ctlValue of zero. When ctlValue was zero, which means there
0107 8547              * is no currently selected item in the pop-up, the first item in the pop-up menu
0108 8547              * would always get drawn anyways. This was because a zero item ID to GetMItem
0109 8547              * was not an invalid item ID but meant get the first item in the menu. So now I
0110 8547              * check for ctlValue of zero before calling GetMItem. Worksheet #BCOJHS083.
0111 8547              *
0112 8547              * When a pop-up is created, the height of the control rect is increased by one
0113 8547              * to account for the bottom drop shadow. The bottom drop shadow needs to be
0114 8547              * made a part of the control rect, so that it will erase correctly.
0115 8547              *
0116 8547              * Now pop-ups are dimmed correctly when they are de-activated.
0117 8547              *
0118 8547              * 27 Mar 89         Harry Yee
0119 8547              *
0120 8547              * I now restore the text mode, foreground color, and text face after drawing result.
0121 8547              *
0122 8547              * 29 Mar 89         Harry Yee
0123 8547              *
0124 8547              * Add some additional control messages in my table. Only new one added that I do
0125 8547              * anything about is the message sent when the state of the window that the pop-up
0126 8547              * is in has changed. In this case I just invalidate the rect.
0127 8547              *
0128 8547              * 30 Mar 89         Harry Yee
0129 8547              *
0130 8547              * I now handle pcount=8 (which means InitialValue=0)
0131 8547              *
0132 8547              * Color tables for pop-ups will now work with refs to handle and resources.
0133 8547              *
0134 8547              * 07 Apr 89         Harry Yee
0135 8547              *
0136 8547              * Fix do_test so that all I do is return my part code. Before I used to
0137 8547              * check to make sure the pt passed was inside the pop-up rect (control mgr
0138 8547              * already does the check for me). WorkSheet #BCORMR583.
0139 8547              *
0140 8547              * 09 Apr 90         Harry Yee
0141 8547              *
0142 8547              * Put back change made 07 Apr 89 since that wasn't it.
0143 8547              *
0144 8547              * In do_track routine I was saving the PopUpMenuSelect return value in <currentSelection
0145 8547              * which is defined on my stack. Routine DrawResult was using this same value to store
0146 8547              * the master SCB which is why in 640 mode we always get the result that an item was
0147 8547              * selected and in 320 mode nothing was ever selected. I now save <currentSelection on
0148 8547              * the stack before calling DrawResult. WorkSheet #BCORMR583.
0149 8547              *
0150 8547              * 12 Apr 89         Steven Glass
0151 8547              *
0152 8547              * Reject events if control is invisible or inactive.
0153 8547              *
0154 8547              * 27 Apr 89         Harry Yee & mensch & Johnny Joystick
0155 8547              *
0156 8547              * Popup menus were not checking the ctrlparam field for zero in the drag routine. This caused
0157 8547              * popups not to be able to be dragged with dragControl call.
0158 8547              *
0159 8547              * 20 May 89         Yee
0160 8547              *
0161 8547              * Was not disposing of the handle for the menu record when a pop-up control was being killed.
0162 8547              *
0163 8547              * If the color table was a resource, it was not getting released. If it is a resource,
0164 8547              * it now gets released in do_dispose.
0165 8547              *
0166 8547              **********************************************************************
0167 8547
0168 8547                       blanks off 
0169 8547                       string asis 
0170 8547
0171 8547                       print push 
0172 8547                       print off 
0173 8547
0174 8547                       include 'all.macros' 
0175 8547
0176 8547                       include 'e16.event' 
0177 8547                       INCLUDE 'e16.control' 
0178 8547                       INCLUDE 'e16.quickdraw' 
0179 8547                       INCLUDE 'e16.menu' 
0180 8547                       INCLUDE 'e16.window' 
0181 8547                       INCLUDE 'e16.resources' 
0182 8547
0183 8547              oqdiconHeight  EQU 4 
0184 8547              oqdiconWidth  EQU 6 
0185 8547
0186 8547              ;;;owmTaskData 	EQU 16
0187 8547
0188 8547              True     equ   $FFFF
0189 8547              False    equ   $0000
0190 8547
0191 8547                       print pop 
0192 8547
0193 8547                       ENTRY MoveRect 
0194 8547                       ENTRY MoveRectIn 
0195 8547                       ENTRY PushPtrToRect 
0196 8547                       ENTRY PushPtrToRect2 
0197 8547                       ENTRY DerefMenuHand 
0198 8547                       ENTRY SetNewMenuBar 
0199 8547                       ENTRY SetupColorTable 
0200 8547                       ENTRY DrawPopUpBox 
0201 8547                       ENTRY DefColorTable 
0202 8547                       ENTRY Dimmed 
0203 8547                       ENTRY Nor_Mask 
0204 8547                       ENTRY DrawResult 
0205 8547                       ENTRY ClearResult 
0206 8547
0207 8547              ;=======================================================================
0208 8547              ;
0209 8547              ; Some Global equates used throughout
0210 8547              ;
0211 8547
0212 8547              MaxMessages equ   19
0213 8547
0214 8547              y1       equ   0                        ; rect offsets
0215 8547              x1       equ   2
0216 8547              y2       equ   4
0217 8547              x2       equ   6
0218 8547
0219 8547              T_LEADING equ   2                       ; Top leading.
0220 8547              B_LEADING equ   2                       ; Bottom leading.
0221 8547
0222 8547              _M_CACHE equ   $FFF7
0223 8547              M_POPUP  equ   $0001                    ; 0 = regular menu, 1 = pop-up menu
0224 8547
0225 8547
0226 8547              NewCtlRecord RECORD  0 
0227 8547              ;---------------------------------------------------------------
0228 8547              ctlNext  ds.l  1 
0229 8547              ctlOwner ds.l  1 
0230 8547              ctlRect  ds.w  4 
0231 8547              ctlFlag  ds.b  1 
0232 8547              ctlHilite ds.b  1 
0233 8547              ctlValue ds.w  1 
0234 8547              ctlProc  ds.l  1 
0235 8547              ctlAction ds.l  1 
0236 8547              ctlData  ds.l  1 
0237 8547              ctlRefCon ds.l  1 
0238 8547              ctlColor ds.l  1 
0239 8547              ctlReserved ds.b  16 
0240 8547              ctlID    ds.l  1 
0241 8547              ctlMoreFlags ds.w  1 
0242 8547              ctlVersion ds.w  1 
0243 8547              ctlOptionalData  
0244 8547              RecordSize  
0245 8547              ;---------------------------------------------------------------
0246 8547              ; Values kept in ctlReserved by various controls
0247 8547              ;---------------------------------------------------------------
0248 8547              ;
0249 8547              ; Button Controls
0250 8547              ;
0251 8547              ctlKey1  equ   ctlReserved
0252 8547              ctlKey2  equ   ctlKey1+1
0253 8547              ctlKeyMods equ   ctlKey2+1
0254 8547              ctlKeyModsCareBits equ   ctlKeyMods+2
0255 8547              ;
0256 8547              ; StatText Controls
0257 8547              ;
0258 8547              ctlJust  equ   ctlReserved
0259 8547
0260 8547                       ENDR 
0261 8547
0262 8547
0263 8547              ;=======================================================================
0264 8547              ;
0265 8547              ; This is the control record for a popup control
0266 8547              ;
0267 8547
0268 8547              PopUpCtlRecord RECORD  0 
0269 8547
0270 8547              ctlNext  DS.L  1 
0271 8547              ctlOwner DS.L  1                        ; port containing the pop-up control
0272 8547              ctlRect  DS.W  4                        ; total rectangle, title + pop-up box
0273 8547              ctlFlag  DS.B  1 
0274 8547              ctlHilite DS.B  1 
0275 8547              ctlValue DS.W  1                        ; current selection for pop-up
0276 8547              ctlProc  DS.L  1                        ; control type
0277 8547              ctlAction DS.L  1 
0278 8547              ctlData  DS.L  1 
0279 8547              ctlRefCon DS.L  1 
0280 8547              ctlColor DS.L  1                        ; ptr to color table
0281 8547              MenuRef  DS.L  1                        ; make this record look like a menu record
0282 8547              MenuEnd  DS.L  1                        ; signifies end of menu list, must be zero
0283 8547              PopUpRect DS.W  4                       ; "hot spot" for popping up pop-up
0284 8547              ctlID    DS.L  1 
0285 8547              ctlMoreFlags DS.W  1 
0286 8547              ctlVersion DS.W  1 
0287 8547              TitleWidth DS.W  1                      ; width of title
0288 8547
0289 8547              Size     DS.B  1 
0290 8547
0291 8547                       ENDR 
0292 8547
0293 8547              ;=======================================================================
0294 8547              ;
0295 8547              ; This is the template record for a pop-up control
0296 8547
0297 8547              PopUpTemplate RECORD  0 
0298 8547
0299 8547              pCount   DS.W  1                        ; parameter count (must be at least 6)
0300 8547              ID       DS.L  1                        ; ID for the control
0301 8547              Rect     DS.W  4                        ; bounding rectangle
0302 8547              ProcRef  DS.L  1                        ; Ref to DefProc, determines control type
0303 8547              Flags    DS.W  1                        ; old style flag word
0304 8547              MoreFlags DS.W  1                       ; new flag word
0305 8547              RefCon   DS.L  1                        ; application defined
0306 8547              TitleWidth DS.W  1                      ; width reserved for pop up title
0307 8547              MenuRef  DS.L  1                        ; reference to menu record.
0308 8547              InitialValue DS.W  1                    ; initial value of the selected item in pop-up
0309 8547              ColorTableRef DS.L  1                   ; if pCount = 10 then the colorTableRef is value is valid
0310 8547
0311 8547                       ENDR 
0312 8547
0313 8547              ;=======================================================================
0314 8547              ;
0315 8547              ; Define stack and direct page use
0316 8547
0317 8547                             DEFINESTACK  
0318 8547              Temp           LONG                        ; define some local variables
0319 8547              CtlPtr         LONG  
0320 8547              Rect           block 8  
0321 8547              Word1          word  
0322 8547              Word2          word  
0323 8547              Word3          word  
0324 8547              Word4          word  
0325 8547              Word5          word  
0326 8547              Word6          word  
0327 8547              Word7          word  
0328 8547
0329 8547              OrigD          WORD                        ; caller's saved direct page register
0330 8547              OrigB          byte                        ; caller's saved data bank register
0331 8547              RtnAddr        block 3                     ; RTL address back to Control Manager
0332 8547              theCtlHandle   LONG                        ; handle to control record
0333 8547              CtlParam       LONG                        ; add'l parameter passed to DefProc
0334 8547              CtlCode        WORD                        ; operation to perform
0335 8547              ReturnValue    LONG                        ; space for return value to Ctl Mgr.
0336 8547
0337 8547              ZPageSize equ   OrigD-Temp
0338 8547
0339 8547
0340 8547                       title 'PopUpDefProc -- MainEntry' 
0341 8547
0342 8547              ****************************************************************
0343 8547              *
0344 8547              PopUpProc PROC EXPORT 
0345 8547              *
0346 8547              * This is the def_proc for PopUp controls.  When this
0347 8547              * routine gets control, the stack looks as described below.
0348 8547              *
0349 8547              *
0350 8547              *
0351 8547              * Inputs:           On entry, the parameters are passed to us on the stack.
0352 8547              *
0353 8547              *                   |                   | Previous Contents
0354 8547              *                   |-------------------|
0355 8547              *                   |    ReturnValue    | LONG - Space for return value
0356 8547              *                   |-------------------|
0357 8547              *                   |    CtlCode        | WORD - operation to perform
0358 8547              *                   |-------------------|
0359 8547              *                   |    CtlParam       | LONG - add'l parameter
0360 8547              *                   |-------------------|
0361 8547              *                   |    theCtlHandle   | LONG - Handle to control record
0362 8547              *                   |-------------------|
0363 8547              *                   |    RtnAddr        | 3 BYTES - RTL address
0364 8547              *                   |-------------------|
0365 8547              *                   |                   | <-- Stack pointer
0366 8547              *
0367 8547              * Outputs:          Put something into ReturnValue, pull off the parameters,
0368 8547              *                   and return to the Control Manager.
0369 8547              *
0370 8547              *                   |                   | Previous Contents
0371 8547              *                   |-------------------|
0372 8547              *                   |    ReturnValue    | LONG - Space for return value
0373 8547              *                   |-------------------|
0374 8547              *                   |    RtnAddr        | 3 BYTES - RTL address
0375 8547              *                   |-------------------|
0376 8547              *                   |                   | <-- Stack pointer
0377 8547              *
0378 8547              * External Refs:
0379 8547                       import do_draw 
0380 8547                       import do_nothing 
0381 8547                       import do_disposePopUp 
0382 8547                       import do_test 
0383 8547                       import do_init 
0384 8547                       import do_newvalue 
0385 8547                       import do_track 
0386 8547                       import do_move 
0387 8547                       import do_recsize 
0388 8547                       import do_key 
0389 8547                       import do_stateChange 
0390 8547                       import SelfMod1Low 
0391 8547                       import SelfMod1High 
0392 8547                       import SelfMod2Low 
0393 8547                       import SelfMod2High 
0394 8547                       import SelfMod3Low 
0395 8547                       import SelfMod3High 
0396 8547              *
0397 8547              * Entry Points:
0398 8547              *                   none
0399 8547              *
0400 8547                       longa on                       ; mode
0401 8547                       longi on 
0402 8547              *
0403 8547              ****************************************************************
0404 8547
0405 8547 8B                    phb                            ; save the Data Bank register
0406 8548 0B                    phd                            ; save the Direct Page register
0407 8549
0408 8549 4B                    phk                            ; switch data bank to program bank
0409 854A AB                    plb   
0410 854B
0411 854B 3B                    tsc   
0412 854C 38                    sec   
0413 854D E9 1E 00              sbc   #ZPageSize
0414 8550 1B                    tcs                            ; switch Direct Page into stack
0415 8551 5B                    tcd   
0416 8552
0417 8552 A5 2D                 lda   <CtlCode
0418 8554 C9 0C 00              cmp   #recSize
0419 8557 F0 15                 beq   SkipDeref
0420 8559
0421 8559 A0 04 00              ldy   #4
0422 855C B7 25                 lda   [<theCtlHandle],y
0423 855E 09 00 80              ora   #$8000                   ; lock the handle
0424 8561 97 25                 sta   [<theCtlHandle],y
0425 8563
0426 8563 A7 25                 lda   [<theCtlHandle]          ; dereference the handle
0427 8565 85 05                 sta   <CtlPtr
0428 8567 A0 02 00              ldy   #2
0429 856A B7 25                 lda   [<theCtlHandle],y
0430 856C 85 07                 sta   <CtlPtr+2
0431 856E
0432 856E A5 2D        SkipDeref lda   <CtlCode                ; get routine # to call
0433 8570 C9 14 00              cmp   #MaxMessages+1
0434 8573 90 03                 blt   ShiftIt
0435 8575 A9 06 00              lda   #6                       ; force unknown codes to null events
0436 8578              ShiftIt   
0437 8578 0A                    asl   a
0438 8579 AA                    tax   
0439 857A FC AC 85              jsr   (ActionTable,x)
0440 857D
0441 857D 85 2F                 sta   <ReturnValue             ; save the return value
0442 857F 86 31                 stx   <ReturnValue+2
0443 8581
0444 8581 A5 2D                 lda   <CtlCode
0445 8583 C9 0C 00              cmp   #recsize
0446 8586 F0 0A                 beq   SkipUnlock
0447 8588
0448 8588 A0 04 00              ldy   #4                       ; unlock the control handle
0449 858B B7 25                 lda   [<theCtlHandle],y
0450 858D 29 FF 7F              and   #$7FFF
0451 8590 97 25                 sta   [<theCtlHandle],y
0452 8592
0453 8592 3B           SkipUnlock tsc   
0454 8593 18                    clc   
0455 8594 69 1E 00              adc   #ZPageSize
0456 8597 1B                    tcs   
0457 8598
0458 8598 A5 22                 lda   <RtnAddr                 ; move the return address up
0459 859A 85 2C                 sta   <ReturnValue-3
0460 859C A5 23                 lda   <RtnAddr+1
0461 859E 85 2D                 sta   <ReturnValue-2
0462 85A0
0463 85A0 2B                    pld                            ; restore caller's Data Bank and
0464 85A1 AB                    plb                            ; Direct Page registers
0465 85A2
0466 85A2 68                    pla                            ; remove 10 bytes
0467 85A3 68                    pla   
0468 85A4 68                    pla   
0469 85A5 68                    pla   
0470 85A6 68                    pla   
0471 85A7
0472 85A7 A9 00 00              lda   #0
0473 85AA 18                    clc   
0474 85AB
0475 85AB 6B                    rtl                            ; back to the caller
0476 85AC
0477 85AC              ;
0478 85AC A7 87        ActionTable DC W:do_draw                0 Draw simple button.
0479 85AE DB 85                 DC W:do_nothing                1 Compute drag RECT.
0480 85B0 7C 87                 DC W:do_test                   2 Common hit test routine.
0481 85B2 E0 85                 DC W:do_init                   3 Initialize the control.
0482 85B4 DB 85                 DC W:do_nothing                4 Dispose.
0483 85B6 A7 87                 DC W:do_draw                   5 New value.
0484 85B8 DB 85                 DC W:do_nothing                6 Compute Thumber constrains.
0485 85BA 54 88                 DC W:do_track                  7 Drag the indicator.
0486 85BC DB 85                 DC W:do_nothing                8 Auto action.
0487 85BE 36 88                 DC W:do_newvalue               9 New value.
0488 85C0 DB 85                 DC W:do_nothing                10 Set min max.
0489 85C2 3B 89                 DC W:do_move                   11 Move button.
0490 85C4 D4 85                 DC W:do_recsize                12 Return size of standard record.
0491 85C6 53 89                 DC W:do_key                    13 take key or menu event
0492 85C8 DB 85                 DC W:do_nothing                14 ctlChangeTarget
0493 85CA DB 85                 DC W:do_nothing                15 ctlChangeBounds
0494 85CC DB 85                 DC W:do_nothing                16 ctlWindChangeSize
0495 85CE DB 85                 DC W:do_nothing                17 ctlHandleTab
0496 85D0 DB 85                 DC W:do_nothing                18 ctlHideCntl
0497 85D2 C3 89                 DC W:do_StateChange            19 ctlWindStateChange, tells us state of control changed
0498 85D4                       ENDP 
0499 85D4
0500 85D4
0501 85D4                       title 'PopUpDefProc -- do_recsize' 
0502 85D4              ****************************************************************
0503 85D4              *
0504 85D4              do_recsize PROC 
0505 85D4              *
0506 85D4              * Returns the size of the control record.
0507 85D4              *
0508 85D4              *
0509 85D4              * Inputs:
0510 85D4              *                   none
0511 85D4              *
0512 85D4              * Outputs:
0513 85D4              *                   a-reg & x-reg hold result for def proc
0514 85D4              *
0515 85D4              * External Refs:
0516 85D4              *                   none
0517 85D4              *
0518 85D4              * Entry Points:
0519 85D4              *                   none
0520 85D4              *
0521 85D4                       longa on                       ; mode
0522 85D4                       longi on 
0523 85D4              *
0524 85D4              ****************************************************************
0525 85D4
0526 85D4 A9 42 00              lda   #PopUpCtlRecord.Size
0527 85D7 A2 00 00              ldx   #0                       High word of size.
0528 85DA
0529 85DA 60                    rts   
0530 85DB
0531 85DB                       ENDP 
0532 85DB
0533 85DB
0534 85DB                       title 'PopUpDefProc -- Do_Nothing' 
0535 85DB              ****************************************************************
0536 85DB              *
0537 85DB              do_nothing PROC 
0538 85DB              *
0539 85DB              * This is the routine we use when there is nothing to do.
0540 85DB              * It just returns zeros in the a and x registers.
0541 85DB              *
0542 85DB              *
0543 85DB              * Inputs:
0544 85DB              *                   ctlHandle
0545 85DB              *                   ctlPtr
0546 85DB              *
0547 85DB              * Outputs:
0548 85DB              *                   a-reg & x-reg hold result for def proc
0549 85DB              *
0550 85DB              * External Refs:
0551 85DB              *                   none
0552 85DB              *
0553 85DB              * Entry Points:
0554 85DB              *                   none
0555 85DB              *
0556 85DB                       longa on                       ; mode
0557 85DB                       longi on 
0558 85DB              *
0559 85DB              ****************************************************************
0560 85DB
0561 85DB A9 00 00              lda   #0                       Nothing flag.
0562 85DE AA                    tax   
0563 85DF
0564 85DF 60                    rts   
0565 85E0
0566 85E0                       ENDP 
0567 85E0
0568 85E0
0569 85E0                       title 'PopUpDefProc -- Do_Init' 
0570 85E0              ;=======================================================================
0571 85E0              ;
0572 85E0              ;                   Do_Init
0573 85E0              ;
0574 85E0              ; Initialize a bunch of things and copy the pop-up template data into the
0575 85E0              ; control record.
0576 85E0              ;
0577 85E0              ; Do_Init copies various fields from the PopUpTemplate to the Control Record.
0578 85E0              ; The fields ID, Rect, ProcRef, Flags, MoreFlags and RefCon are automatically
0579 85E0              ; copied from our template to the control record by the control manager.
0580 85E0              ;
0581 85E0              ; The main thing this routine does is calculate the pop-up's rect and the true
0582 85E0              ; control rect depending on what the titlewidth is set.
0583 85E0              ;
0584 85E0              ;=======================================================================
0585 85E0              do_init  PROC 
0586 85E0
0587 85E0                       longa on                       ; mode
0588 85E0                       longi on 
0589 85E0
0590 85E0              fontheight equ   word1                  ; redefine some direct page locations
0591 85E0              descent  equ   word2
0592 85E0              widmax   equ   word3
0593 85E0              leading  equ   word4
0594 85E0              title_width equ   word5
0595 85E0
0596 85E0                       WITH PopUpCtlRecord 
0597 85E0
0598 85E0 48                    pha                            ; space for handle from one of the
0599 85E1 48                    pha                            ; newmenu calls
0600 85E2
0601 85E2 A0 14 00              ldy   #PopUpTemplate.MoreFlags ; first find out what format the
0602 85E5 B7 29                 lda   [<ctlparam],y            ; menu is in, text stream or template
0603 85E7 29 04 00              and   #FMenuDefIsText          ; call NewMenu for text stream,
0604 85EA D0 1A                 bne   CallNewMenu              ; NewMenu2 for template
0605 85EC
0606 85EC B7 29                 lda   [<ctlparam],y
0607 85EE 29 03 00              and   #$0003                   ; menu is in format of MenuTemplate
0608 85F1 48                    pha                            ; get verb to find out whether menu is
0609 85F2 A0 1E 00              ldy   #PopUpTemplate.MenuRef+2 ; a ptr, handle, or resource ID
0610 85F5 B7 29                 lda   [<ctlparam],y
0611 85F7 48                    pha                            ; reference to MenuTemplate
0612 85F8 88                    dey   
0613 85F9 88                    dey   
0614 85FA B7 29                 lda   [<ctlparam],y
0615 85FC 48                    pha                            ; copies MenuTemplate, into a
0616 85FD A2 0F 3E 22           _NewMenu2                      ; menu record returning handle to it
0617 8604
0618 8604 80 12                 bra   getmenuHand
0619 8606
0620 8606 A0 1E 00     CallNewMenu ldy   #PopUpTemplate.MenuRef+2 ; pointer to an array of menu lines and
0621 8609 B7 29                 lda   [<ctlparam],y            ; item lines
0622 860B 48                    pha   
0623 860C 88                    dey   
0624 860D 88                    dey   
0625 860E B7 29                 lda   [<ctlparam],y
0626 8610 48                    pha                            ; let menu mgr parse our menu item list
0627 8611 A2 0F 2D 22           _NewMenu                       ; create menu record and return handle to it
0628 8618
0629 8618 A0 28 00     getmenuHand ldy   #PopUpCtlRecord.MenuRef
0630 861B 68                    pla   
0631 861C 97 05                 sta   [<ctlPtr],y              ; store the menu handle in our control
0632 861E C8                    iny                            ; record
0633 861F C8                    iny   
0634 8620 68                    pla   
0635 8621 97 05                 sta   [<ctlPtr],y
0636 8623
0637 8623 A0 2C 00              ldy   #MenuEnd                 ; must zero out the next four bytes after the location
0638 8626 A9 00 00              lda   #0                       ; where the menu ref is stored in the control record
0639 8629 97 05                 sta   [<ctlPtr],y              ; remember, our control record has the same structure as
0640 862B C8                    iny                            ; a menu bar record, so menuEnd signifies end of menu list
0641 862C C8                    iny   
0642 862D 97 05                 sta   [<ctlPtr],y
0643 862F
0644 862F              ;
0645 862F              ; calculate the width of the pop-up's title
0646 862F              ;
0647 862F A0 12 00              ldy   #PopUpTemplate.Flags
0648 8632 B7 29                 lda   [<ctlparam],y
0649 8634 AA                    tax   
0650 8635 29 10 00              and   #FDontDrawTitle          ; first check if FDontDrawTitle flag is set, if it is then
0651 8638 F0 05                 beq   @888                     ; title width is zero
0652 863A A9 00 00              lda   #0
0653 863D 80 4C                 bra   storeTitleWidth
0654 863F
0655 863F A0 1A 00     @888     ldy   #PopUpTemplate.TitleWidth
0656 8642 B7 29                 lda   [<ctlparam],y            ; now check if app has specifically set a title width
0657 8644 F0 0A                 beq   @999                     ; if they have then use this width only if title left just.
0658 8646 A8                    tay                            ; save title width app has set
0659 8647 8A                    txa                            ; remember moreFlags still in x-reg
0660 8648 29 02 00              and   #FRightJustifyTitle
0661 864B D0 03                 bne   @999
0662 864D 98                    tya   
0663 864E 80 3B                 bra   storeTitleWidth
0664 8650
0665 8650 48           @999     pha                            ; space for StringWidth call
0666 8651
0667 8651 48                    pha                            ; space for ptr to menu title
0668 8652 48                    pha   
0669 8653 A0 2A 00              ldy   #PopUpCtlRecord.MenuRef+2
0670 8656 B7 05                 lda   [<ctlPtr],y
0671 8658 48                    pha   
0672 8659 88                    dey   
0673 865A 88                    dey   
0674 865B B7 05                 lda   [<ctlPtr],y              ; this routine checks to see if the menu title ref
0675 865D 48                    pha                            ; is a ptr, handle, or resource ID  and
0676 865E A2 0F 44 22           _GetResMTitle                  ; returns ptr (pascal string) to the menu title
0677 8665 A3 01                 lda   1,s                      ; check if the title is the apple logo
0678 8667 85 01                 sta   <temp
0679 8669 A3 03                 lda   3,s
0680 866B 85 03                 sta   <temp+2
0681 866D A7 01                 lda   [<temp]
0682 866F C9 01 40              cmp   #$4001
0683 8672 F0 05                 beq   ItsTheAppleLogo
0684 8674 C9 01 FF              cmp   #$FF01
0685 8677 D0 09                 bne   NotAppleLogo
0686 8679
0687 8679              ItsTheAppleLogo  
0688 8679 68                    pla                            ; get ptr to title off the stack
0689 867A 68                    pla   
0690 867B A9 18 00              lda   #24                      ; width of apple logo
0691 867E 83 01                 sta   1,s
0692 8680 80 0A                 bra   GotWidth
0693 8682
0694 8682 A2 04 A9 22  NotAppleLogo _StringWidth 
0695 8689 80 01                 bra   GotWidth
0696 868B
0697 868B              storeTitleWidth  
0698 868B 48                    pha   
0699 868C 20 E1 89     GotWidth jsr   derefmenuhand
0700 868F 68                    pla   
0701 8690 A0 0E 00              ldy   #oTitleWidth
0702 8693 97 01                 sta   [<temp],y
0703 8695
0704 8695 A0 0A 00              ldy   #oMenuFlag
0705 8698 B7 01                 lda   [<temp],y
0706 869A 29 F7 FF              and   #_M_CACHE                ; pop-up menus cannont be cached
0707 869D 09 01 00              ora   #M_POPUP                 ; set the flag in menu that says menu is a pop-up
0708 86A0 97 01                 sta   [<temp],y
0709 86A2
0710 86A2              ;==================================================
0711 86A2              ;
0712 86A2              ; Initialize some rects and calc a bunch of stuff
0713 86A2              ;
0714 86A2
0715 86A2              ; first check to see if the user wants me to calculate the bottom right bounds of the
0716 86A2              ; control rect for them
0717 86A2
0718 86A2 A0 08 00              ldy   #ctlRect                 ; move the current control record into our direct page
0719 86A5 20 11 8D              jsr   MoveRect                 ; so we can get to it easier
0720 86A8
0721 86A8 A5 0D                 lda   <rect+y2                 ; is bottom of rect defined?
0722 86AA D0 24                 bne   BottomDefined
0723 86AC
0724 86AC F4 00 00              pea   0                        ; get current font size and calculate height of our pop-up
0725 86AF 7B                    tdc                            ; space for font info record is on the stack
0726 86B0 18                    clc   
0727 86B1 69 11 00              adc   #fontHeight
0728 86B4 48                    pha   
0729 86B5 A2 04 96 22           _GetFontInfo 
0730 86BC
0731 86BC A5 13                 lda   <descent                 ; get font height and add in some slop
0732 86BE 18                    clc   
0733 86BF 69 02 00              adc   #B_LEADING
0734 86C2 85 13                 sta   <descent
0735 86C4
0736 86C4 18                    clc   
0737 86C5 65 11                 adc   <fontHeight
0738 86C7 69 02 00              adc   #T_LEADING
0739 86CA 85 11                 sta   <fontHeight
0740 86CC
0741 86CC 65 09                 adc   <rect+y1                 ; we now have a new bottom
0742 86CE 85 0D                 sta   <rect+y2
0743 86D0
0744 86D0              BottomDefined  
0745 86D0
0746 86D0              ;------------------------------------------------------------
0747 86D0              ; now we check the right side of the pop-up
0748 86D0              ; right = length of title plus length of pop-up box
0749 86D0              ;      length of title = actual length of title string or TitleWidth if non-zero
0750 86D0              ;      length of pop-up = widest item in menu or whatever user as defined for right side
0751 86D0
0752 86D0 A5 0F                 lda   <rect+x2                 ; use apps right side?
0753 86D2 D0 3C                 bne   RightDefined
0754 86D4
0755 86D4 20 F4 8C              jsr   setNewMenuBar            ; switch menu bars, orig menu bar is put on stack
0756 86D7
0757 86D7 20 E1 89              jsr   derefmenuhand
0758 86DA
0759 86DA F4 00 00              pea   0                        ; new width, 0 for automatic calculation
0760 86DD F4 00 00              pea   0                        ; new heighth, 0 for automatic calculation
0761 86E0 A0 00 00              ldy   #oMenuID                 ; id of menu record (ZERO)
0762 86E3 B7 01                 lda   [<temp],y
0763 86E5 48                    pha   
0764 86E6 A2 0F 1C 22           _CalcMenuSize                  ; let the menu manager calculate widest item in the menu
0765 86ED
0766 86ED 20 E1 89              jsr   derefmenuhand
0767 86F0
0768 86F0 A2 0F 39 22           _SetMenuBar                    ; restore original menu Bar
0769 86F7
0770 86F7 20 E1 89              jsr   derefmenuhand            ; deref menu handle one more time just in case it moved
0771 86FA
0772 86FA A0 1A 00              ldy   #PopUpTemplate.TitleWidth
0773 86FD B7 29                 lda   [<ctlparam],y            ; see if title width as been pre-defined
0774 86FF D0 05                 bne   @777                     ; if it has use it, else get the titlewidth we
0775 8701                                                      ; calculated above
0776 8701 A0 0E 00              ldy   #oTitleWidth
0777 8704 B7 01                 lda   [<temp],y
0778 8706
0779 8706 A0 02 00     @777     ldy   #oMenuWidth              ; get width of widest item in menu
0780 8709 18                    clc   
0781 870A 77 01                 adc   [<temp],y                ; add to width of pop-up's title to get right coordinate
0782 870C 65 0B                 adc   <rect+x1
0783 870E 85 0F                 sta   <rect+x2
0784 8710
0785 8710 E6 0D        RightDefined inc   <rect+y2             ; we must account for the bottom drop shadow
0786 8712 A0 30 00              ldy   #PopUpRect               ; now we define our popup rectangle, initially pop-up rect
0787 8715 20 22 8D              jsr   moveRectIn               ; equals the rect of whole control
0788 8718
0789 8718 A0 1A 00              ldy   #PopUpTemplate.TitleWidth
0790 871B B7 29                 lda   [<ctlparam],y            ; check if app has pre-defined the title width
0791 871D D0 05                 bne   @666                     ; if it has use it, else get width we calc. above
0792 871F
0793 871F A0 0E 00              ldy   #oTitleWidth
0794 8722 B7 01                 lda   [<temp],y
0795 8724
0796 8724 18           @666     clc   
0797 8725 65 0B                 adc   <rect+x1
0798 8727 A0 32 00              ldy   #PopUpRect+x1            ; now plug in the real left coordinate for the pop-up rect
0799 872A 97 05                 sta   [<ctlPtr],y
0800 872C
0801 872C A0 0E 00              ldy   #oTitleWidth             ; just in case app wanted title right justified
0802 872F 38                    sec                            ; we have to adjust left coord. of our control rect.
0803 8730 F7 01                 sbc   [<temp],y
0804 8732 85 0B                 sta   <rect+x1
0805 8734
0806 8734 A0 08 00              ldy   #ctlRect
0807 8737 20 22 8D              jsr   MoveRectIn
0808 873A
0809 873A A0 00 00              ldy   #PopUpTemplate.pCount
0810 873D B7 29                 lda   [<ctlparam],y
0811 873F C9 08 00              cmp   #8
0812 8742 F0 07                 beq   NoInitialValue
0813 8744
0814 8744 A0 20 00              ldy   #PopUpTemplate.InitialValue ; get initial value of current selection
0815 8747 B7 29                 lda   [<ctlparam],y            ; for the pop-up and store in control rec
0816 8749 80 03                 bra   storevalue
0817 874B
0818 874B A9 00 00     NoInitialValue lda   #0
0819 874E
0820 874E A0 12 00     storevalue ldy   #PopUpCtlRecord.ctlValue
0821 8751 97 05                 sta   [<ctlPtr],y
0822 8753
0823 8753 A0 00 00              ldy   #PopUpTemplate.pCount
0824 8756 B7 29                 lda   [<ctlparam],y
0825 8758 C9 09 00              cmp   #9
0826 875B F0 0C                 beq   doDefault
0827 875D
0828 875D A0 22 00              ldy   #PopUpTemplate.ColorTableRef
0829 8760 B7 29                 lda   [<ctlparam],y
0830 8762 AA                    tax   
0831 8763 C8                    iny   
0832 8764 C8                    iny   
0833 8765 B7 29                 lda   [<ctlParam],y
0834 8767 80 04                 bra   storeIt
0835 8769
0836 8769 A9 00 00     doDefault lda   #0                      ; Zero for default color table
0837 876C AA                    tax   
0838 876D
0839 876D A0 26 00     storeIt  ldy   #ctlColor+2
0840 8770 97 05                 sta   [<ctlPtr],y              ; high word of color table
0841 8772 88                    dey   
0842 8773 88                    dey   
0843 8774 8A                    txa                            ; x contains low word of color table
0844 8775 97 05                 sta   [<ctlPtr],y
0845 8777
0846 8777                       ENDWITH 
0847 8777
0848 8777 A9 00 00              lda   #0
0849 877A AA                    tax   
0850 877B 60                    rts   
0851 877C
0852 877C                       ENDP 
0853 877C
0854 877C
0855 877C                       title 'PopUpDefProc -- do_test' 
0856 877C              ****************************************************************
0857 877C              *
0858 877C              do_test  PROC 
0859 877C              *
0860 877C              * Test if the mouse is down in the control.
0861 877C              *
0862 877C              *
0863 877C              * Inputs:
0864 877C              *                   ctlParam = point to check
0865 877C              *
0866 877C              *
0867 877C              * Outputs:
0868 877C              *                   a-reg and x-reg are always zero
0869 877C              *
0870 877C              * External Refs:
0871 877C              *                   none
0872 877C              *
0873 877C              * Entry Points:
0874 877C              *                   none
0875 877C              *
0876 877C                       longa on                       ; mode
0877 877C                       longi on 
0878 877C              *
0879 877C              ****************************************************************
0880 877C
0881 877C 48                    pha                            ; space for result
0882 877D F4 00 00              pea   0000                     ; push pointer to point to check
0883 8780 7B                    tdc   
0884 8781 18                    clc   
0885 8782 69 29 00              adc   #ctlparam
0886 8785 48                    pha   
0887 8786 A0 08 00              ldy   #PopUpCtlRecord.CtlRect
0888 8789 20 11 8D              jsr   MoveRect                 ; push ptr to the control rectangle
0889 878C C6 0D                 dec   <rect+y2                 ; bottom drop shadow is not part of "hot spot"
0890 878E 20 33 8D              jsr   PushPtrToRect
0891 8791 A2 04 4F 22           _PtInRect                      ; is mouse in the pop-up control's rect
0892 8798 68                    pla   
0893 8799 F0 05                 beq   Ignore
0894 879B
0895 879B A9 A0 00              lda   #$A0
0896 879E 80 03                 bra   GetOut
0897 87A0
0898 87A0 A9 00 00     Ignore   lda   #0                       Return that we want to ignore this.
0899 87A3
0900 87A3 A2 00 00     GetOut   ldx   #0                       high word zero
0901 87A6
0902 87A6 60                    rts   
0903 87A7
0904 87A7                       ENDP 
0905 87A7
0906 87A7
0907 87A7                       title 'PopUpDefProc -- Do_Draw' 
0908 87A7              ****************************************************************
0909 87A7              *
0910 87A7              do_draw  PROC 
0911 87A7              *
0912 87A7              * Draws the control using DrawPopUp.
0913 87A7              *
0914 87A7              *
0915 87A7              * Inputs:
0916 87A7              *                   ctlHandle
0917 87A7              *                   ctlPtr
0918 87A7              *                   ctlParam = high-order word tells us if control is active or not, $FFFF=not active
0919 87A7              *                              low-order word = part code.
0920 87A7              *
0921 87A7              * Outputs:
0922 87A7              *                   a-reg and x-reg are zero.
0923 87A7              *
0924 87A7              * External Refs:
0925 87A7                       import LoadResource 
0926 87A7              *
0927 87A7              * Entry Points:
0928 87A7              *                   none
0929 87A7              *
0930 87A7                       longa on                       ; mode
0931 87A7                       longi on 
0932 87A7              *
0933 87A7              ****************************************************************
0934 87A7                       WITH PopUpCtlRecord 
0935 87A7
0936 87A7              Mode     equ   word7
0937 87A7
0938 87A7 A0 10 00              ldy   #ctlFlag                 ; check if the invisible flag is set
0939 87AA B7 05                 lda   [<ctlPtr],y
0940 87AC 29 80 00              and   #$0080                   ; if high bit of flag is set then its invisible
0941 87AF F0 03                 beq   notInvisible
0942 87B1 82 7D 00              brl   noDraw
0943 87B4
0944 87B4 48           notInvisible pha                        ; find out what mode we're in first
0945 87B5 A2 04 17 22           _GetMasterSCB 
0946 87BC 68                    pla   
0947 87BD 29 80 00              and   #$0080
0948 87C0 85 1D                 sta   <mode
0949 87C2
0950 87C2 20 F4 8C              jsr   setNewMenuBar            ; set menu bar to the control handle, old menu bar
0951 87C5                                                      ; handle is still on the stack
0952 87C5 20 FB 89              jsr   SetupColorTable          ; set up color table and put in <word1
0953 87C8
0954 87C8 A0 10 00              ldy   #ctlflag                 ; first check if we need to draw a title
0955 87CB B7 05                 lda   [<ctlPtr],y
0956 87CD 29 10 00              and   #FDontDrawTitle
0957 87D0 D0 13                 bne   NoTitle
0958 87D2
0959 87D2 20 E1 89              jsr   derefmenuhand            ; deref handle to menu and put in <temp
0960 87D5
0961 87D5 F4 00 00              pea   0                        ; draw the pop-up's title
0962 87D8 A0 00 00              ldy   #oMenuID
0963 87DB B7 01                 lda   [<temp],y
0964 87DD 48                    pha   
0965 87DE A2 0F 2C 22           _HiliteMenu 
0966 87E5
0967 87E5 20 17 8C     NoTitle  jsr   DrawPopUpBox             ; draw pop-up box and drop shadow
0968 87E8
0969 87E8 A2 00 00              ldx   #0                       ; flag for DrawResult that says PopUpBox was also drawn
0970 87EB                                                      ; this flag tells us we don't have to do some extra setup
0971 87EB                                                      ; work already done in DrawPopUpBox
0972 87EB 20 52 8A              jsr   DrawResult               ; draw current selection in pop-up box
0973 87EE
0974 87EE A5 2B                 lda   <ctlParam+2
0975 87F0 10 38                 bpl   active
0976 87F2
0977 87F2 F4 FD 00              pea   dimmed>>16
0978 87F5 F4 4E 8F              pea   dimmed
0979 87F8 A2 04 32 22           _SetPenMask 
0980 87FF
0981 87FF A0 0A 00              ldy   #PopUpCtlRecord.CtlRect+x1
0982 8802 B7 05                 lda   [<ctlPtr],y
0983 8804 85 0B                 sta   <rect+x1
0984 8806 20 33 8D              jsr   PushPtrToRect
0985 8809 F4 FD 00              pea   color_patt>>16
0986 880C A7 11                 lda   [<word1]
0987 880E 29 F0 00              and   #$00F0
0988 8811 0A                    asl   a
0989 8812 69 4E 8D              adc   #color_patt
0990 8815 48                    pha   
0991 8816 A2 04 57 22           _FillRect 
0992 881D
0993 881D F4 FD 00              pea   nor_mask>>16
0994 8820 F4 56 8F              pea   nor_mask
0995 8823 A2 04 32 22           _SetPenMask                    ; restore pen mask
0996 882A A2 0F 39 22  active   _SetMenuBar                    ; restore original system menu bar
0997 8831 A9 00 00     noDraw   lda   #0
0998 8834 AA                    tax   
0999 8835 60                    rts   
1000 8836
1001 8836                       ENDWITH 
1002 8836
1003 8836                       ENDP 
1004 8836
1005 8836                       title 'PopUpDefProc -- Do_NewValue' 
1006 8836              ****************************************************************
1007 8836              *
1008 8836              do_newValue PROC 
1009 8836              *
1010 8836              * Called by control manager in response to a _SetCtlValue call. This routine redraws the
1011 8836              * result in the pop-up in response to a change in the selected item for the pop-up.
1012 8836              *
1013 8836              *
1014 8836              * Inputs:
1015 8836              *                   ctlHandle
1016 8836              *                   ctlPtr
1017 8836              *                   ctlParam = high-order word is previous value, low-order word is new value.
1018 8836              *
1019 8836              * Outputs:
1020 8836              *                   a-reg and x-reg are zero.
1021 8836              *
1022 8836              * External Refs:
1023 8836                       import DimMyRectangle          ;7-Dec-91 DAL
1024 8836              *
1025 8836              * Entry Points:
1026 8836              *                   none
1027 8836              *
1028 8836                       longa on                       ; mode
1029 8836                       longi on 
1030 8836              *
1031 8836              ****************************************************************
1032 8836                       WITH PopUpCtlRecord 
1033 8836
1034 8836 A0 10 00              ldy   #ctlFlag                 ; check if the invisible flag is set
1035 8839 B7 05                 lda   [<ctlPtr],y
1036 883B 89 80 00              bit   #$0080                   ; if high bit of flag is set then its invisible
1037 883E D0 13                 bne   doNothing
1038 8840
1039 8840 20 F4 8C              jsr   SetNewMenuBar
1040 8843 20 FB 89              jsr   SetupColorTable
1041 8846
1042 8846 A2 FF FF              ldx   #$FFFF
1043 8849 20 52 8A              jsr   DrawResult
1044 884C
1045 884C A2 0F 39 22           _SetMenuBar 
1046 8853
1047 8853 60           doNothing rts   
1048 8854
1049 8854                       ENDP 
1050 8854
1051 8854
1052 8854                       title 'PopUp DefProc -- Do_Track' 
1053 8854              ****************************************************************
1054 8854              *
1055 8854              do_track PROC 
1056 8854              *
1057 8854              * This is the routine that is called when the mouse goes down
1058 8854              * in the control.
1059 8854              *
1060 8854              * The control manager calls this routine because, the
1061 8854              * test routine returned a part code of $80.
1062 8854              *
1063 8854              *
1064 8854              * Inputs:
1065 8854              *                   none
1066 8854              *
1067 8854              * Outputs:
1068 8854              *                   none
1069 8854              *
1070 8854              * External Refs:
1071 8854              *                   none
1072 8854              *
1073 8854              * Entry Points:
1074 8854              *                   none
1075 8854              *
1076 8854                       longa on                       ; mode
1077 8854                       longi on 
1078 8854              *
1079 8854              ****************************************************************
1080 8854                       WITH PopUpCtlRecord 
1081 8854
1082 8854              CurrentSelection equ   word7
1083 8854
1084 8854 A5 29                 lda   <ctlParam
1085 8856 D0 05                 bne   @notZero
1086 8858
1087 8858 A9 00 00              lda   #0
1088 885B AA                    tax   
1089 885C 60                    rts   
1090 885D
1091 885D 20 F4 8C     @notZero jsr   setNewMenuBar            ; set menu bar to that of the control, leaving original
1092 8860                                                      ; menubar still on the stack to be restored when we exit
1093 8860 48                    pha                            ; get current port and leave on stack to be restored
1094 8861 48                    pha                            ; later
1095 8862 A2 04 1C 22           _GetPort 
1096 8869
1097 8869 A0 10 00              ldy   #ctlFlag
1098 886C B7 05                 lda   [<ctlPtr],y
1099 886E 29 10 00              and   #FDontDrawTitle
1100 8871 D0 1A                 bne   NoTitle
1101 8873 B7 05                 lda   [<ctlPtr],y
1102 8875 29 20 00              and   #FDontHiliteTitle
1103 8878 D0 13                 bne   NoTitle
1104 887A
1105 887A 20 E1 89              jsr   derefmenuhand            ; dereference menu's handle and put pointer in <temp
1106 887D
1107 887D F4 FF FF              PushWord #True                 ; hilite the control's title
1108 8880 A0 00 00              ldy   #oMenuID
1109 8883 B7 01                 lda   [<temp],y
1110 8885 48                    pha   
1111 8886 A2 0F 2C 22           _HiliteMenu 
1112 888D
1113 888D A0 30 00     NoTitle  ldy   #PopUpRect               ; convert the upper left corner of the rect to global
1114 8890 20 11 8D              jsr   MoveRect
1115 8893 20 33 8D              jsr   PushPtrToRect
1116 8896 A2 04 84 22           _LocalToGlobal 
1117 889D
1118 889D A0 10 00              ldy   #ctlFlag                 ; find out what port we should set to
1119 88A0 B7 05                 lda   [<ctlPtr],y
1120 88A2 29 04 00              and   #FInWindowOnly
1121 88A5 D0 10                 bne   SamePort
1122 88A7
1123 88A7 48                    pha                            ; use menu mgr's port so we can draw some long menus
1124 88A8 48                    pha   
1125 88A9 A2 0F 1B 22           _GetMenuMgrPort 
1126 88B0 A2 04 1B 22           _SetPort 
1127 88B7
1128 88B7 48           SamePort pha                            ; space for result
1129 88B8
1130 88B8 A0 12 00              ldy   #ctlValue
1131 88BB B7 05                 lda   [<ctlPtr],y              ; current selection
1132 88BD 48                    pha   
1133 88BE
1134 88BE A5 0B                 lda   <rect+x1                 ; upper left corner of where to draw current selection
1135 88C0 48                    pha   
1136 88C1 A5 09                 lda   <rect+y1
1137 88C3 48                    pha   
1138 88C4
1139 88C4 A0 10 00              ldy   #ctlFlag                 ; popup flag, what type to draw (with or w/o white space)
1140 88C7 B7 05                 lda   [<ctlPtr],y
1141 88C9 29 40 00              and   #FType2PopUp
1142 88CC 48                    pha   
1143 88CD
1144 88CD A0 2A 00              ldy   #MenuRef+2               ; handle to the menu record
1145 88D0 B7 05                 lda   [<ctlPtr],y
1146 88D2 48                    pha   
1147 88D3 88                    dey   
1148 88D4 88                    dey   
1149 88D5 B7 05                 lda   [<ctlPtr],y
1150 88D7 48                    pha   
1151 88D8
1152 88D8 A2 0F 3C 22           _PopUpMenuSelect               ; make call to PopUpMenuSelect
1153 88DF
1154 88DF 68                    pla   
1155 88E0 85 1D                 sta   <currentSelection
1156 88E2
1157 88E2 A2 04 1B 22           _SetPort                       ; restore original port
1158 88E9
1159 88E9 A5 1D                 lda   <currentSelection
1160 88EB F0 13                 beq   NoSelection
1161 88ED
1162 88ED A0 12 00              ldy   #ctlValue
1163 88F0 97 05                 sta   [<ctlPtr],y
1164 88F2
1165 88F2 20 FB 89              jsr   SetupColorTable
1166 88F5
1167 88F5 D4 1D                 pei   <currentSelection        ; save it because DrawResult trashes this value
1168 88F7 A2 FF FF              ldx   #$FFFF                   ; flag for DrawResult to setup some additional things
1169 88FA 20 52 8A              jsr   DrawResult
1170 88FD 68                    pla   
1171 88FE 85 1D                 sta   <currentSelection
1172 8900
1173 8900 A0 10 00     NoSelection ldy   #ctlFlag
1174 8903 B7 05                 lda   [<ctlPtr],y
1175 8905 29 10 00              and   #FDontDrawTitle
1176 8908 D0 1A                 bne   bye
1177 890A B7 05                 lda   [<ctlPtr],y
1178 890C 29 20 00              and   #FDontHiliteTitle
1179 890F D0 13                 bne   bye
1180 8911
1181 8911 20 E1 89              jsr   derefmenuhand            ; we need to keep derefing this guy because we can't lock
1182 8914                                                      ; down the handle because most menu mgr calls upon exit
1183 8914                                                      ; unlock this handle
1184 8914 F4 00 00              PushWord #False 
1185 8917 A0 00 00              ldy   #oMenuId
1186 891A B7 01                 lda   [<temp],y
1187 891C 48                    pha   
1188 891D A2 0F 2C 22           _HiliteMenu 
1189 8924
1190 8924 A2 0F 39 22  bye      _SetMenuBar 
1191 892B
1192 892B                       ENDWITH 
1193 892B
1194 892B A5 1D                 lda   <currentSelection
1195 892D F0 05                 beq   noHit
1196 892F A2 A0 00              ldx   #$A0                     ; return part code for the pop-up
1197 8932 80 03                 bra   out
1198 8934
1199 8934 A2 00 00     noHit    ldx   #0
1200 8937
1201 8937 A9 FF FF     out      lda   #True                    ; tell control manage that we handled the drag.
1202 893A
1203 893A 60                    rts   
1204 893B
1205 893B
1206 893B                       ENDP 
1207 893B
1208 893B
1209 893B                       title 'PopUp DefProc -- Do_Move' 
1210 893B              ****************************************************************
1211 893B              *
1212 893B              do_Move  PROC Export 
1213 893B              *
1214 893B              * Updates the pop-up box's rect to the appropriate values. The ctlRect
1215 893B              * has already been changed by the control manager.
1216 893B              *
1217 893B              * Inputs:
1218 893B              *                   none
1219 893B              *
1220 893B              * Outputs:
1221 893B              *                   none
1222 893B              *
1223 893B              * External Refs:
1224 893B              *                   none
1225 893B              *
1226 893B              * Entry Points:
1227 893B              *                   none
1228 893B              *
1229 893B                       longa on                       ; mode
1230 893B                       longi on 
1231 893B              *
1232 893B              ****************************************************************
1233 893B
1234 893B A0 30 00              ldy   #PopUpCtlRecord.PopUpRect
1235 893E 20 3F 8D              jsr   PushPtrToRect2
1236 8941
1237 8941 A5 2B                 lda   <ctlParam+2
1238 8943 48                    pha   
1239 8944 A5 29                 lda   <ctlParam
1240 8946 48                    pha   
1241 8947 A2 04 4B 22           _OffSetRect 
1242 894E
1243 894E A9 00 00              lda   #0
1244 8951 AA                    tax   
1245 8952
1246 8952 60                    rts   
1247 8953
1248 8953                       ENDP 
1249 8953
1250 8953
1251 8953                       title 'PopUp DefProc -- Do_Key' 
1252 8953              ****************************************************************
1253 8953              *
1254 8953              do_key   PROC Export 
1255 8953              *
1256 8953              * Handle a key or menu event.
1257 8953              *
1258 8953              * The event.what will be an Event Manager event (typically
1259 8953              * nullEvt, keyDownEvt, autoKeyEvt) or the special code
1260 8953              * wInSpecial for a menu item (ID in taskData).
1261 8953              *
1262 8953              * ctlParam is the event record.
1263 8953              *
1264 8953              * Inputs:
1265 8953              *                   none
1266 8953              *
1267 8953              * Outputs:
1268 8953              *                   none
1269 8953              *
1270 8953              * External Refs:
1271 8953              *                   none
1272 8953              *
1273 8953              * Entry Points:
1274 8953              *                   none
1275 8953              *
1276 8953                       longa on                       ; mode
1277 8953                       longi on 
1278 8953              *
1279 8953              * 12 Apr 89         Steven Glass
1280 8953              *
1281 8953              * Check the control record for inactive control and invisible
1282 8953              * control.  If either is true, reject the event.
1283 8953              *
1284 8953              ****************************************************************
1285 8953
1286 8953              ; Added 12 Apr 89 SEG
1287 8953 A0 10 00              ldy   #NewCtlRecord.ctlFlag    ;Look at the flag and hilite bytes
1288 8956 B7 05                 lda   [<ctlPtr],y
1289 8958 AA                    tax                            ;(save a momment)
1290 8959 29 00 FF              and   #$FF00                   ;If hilite is FF, we are inactive and should
1291 895C C9 00 FF              cmp   #$FF00                   ;ignore the event.
1292 895F F0 5D                 beq   DontWantIt
1293 8961 8A                    txa                            ;Now, check the invis bit
1294 8962 29 80 00              and   #$0080                   ;If invis, we don't want it either.
1295 8965 D0 57                 bne   DontWantIt
1296 8967              ; End Addition
1297 8967
1298 8967 A5 2B                 lda   <ctlParam+2              ;pointer to task record containing char to check
1299 8969 48                    pha   
1300 896A A5 29                 lda   <ctlParam
1301 896C 48                    pha   
1302 896D A5 27                 lda   <theCtlHandle+2
1303 896F 48                    pha   
1304 8970 A5 25                 lda   <theCtlHandle
1305 8972 48                    pha   
1306 8973 A2 0F 09 22           _MenuKey 
1307 897A
1308 897A A0 10 00              ldy   #owmTaskData
1309 897D B7 29                 lda   [<ctlParam],y
1310 897F D0 03                 bne   @1
1311 8981 82 3A 00              brl   DontWantIt
1312 8984
1313 8984 A0 12 00     @1       ldy   #PopUpCtlRecord.ctlvalue
1314 8987 97 05                 sta   [<ctlPtr],y
1315 8989
1316 8989 20 F4 8C              jsr   SetNewMenuBar
1317 898C 20 FB 89              jsr   SetupColorTable
1318 898F
1319 898F A2 FF FF              ldx   #$FFFF
1320 8992 20 52 8A              jsr   DrawResult
1321 8995
1322 8995 A0 10 00              ldy   #PopUpCtlRecord.ctlFlag
1323 8998 B7 05                 lda   [<ctlPtr],y              ; check if there is a title or not
1324 899A 29 10 00              and   #FDontDrawTitle
1325 899D D0 13                 bne   noTitle
1326 899F
1327 899F 20 E1 89              jsr   derefmenuhand
1328 89A2
1329 89A2 F4 00 00              pea   0                        ;unhilite the popup's title highlighted by MenuKey
1330 89A5 A0 00 00              ldy   #oMenuID
1331 89A8 B7 01                 lda   [<temp],y
1332 89AA 48                    pha   
1333 89AB A2 0F 2C 22           _HiliteMenu 
1334 89B2
1335 89B2 A2 0F 39 22  noTitle  _SetMenuBar 
1336 89B9
1337 89B9 A9 FF FF              lda   #$FFFF                   ;Return true for having handled event
1338 89BC AA                    tax   
1339 89BD 60                    rts   
1340 89BE
1341 89BE A9 00 00     DontWantIt lda   #0                     ;Return False, don't want event.
1342 89C1 AA                    tax   
1343 89C2
1344 89C2 60                    rts   
1345 89C3
1346 89C3                       ENDP 
1347 89C3
1348 89C3
1349 89C3                       title 'PopUp DefProc -- Do_StateChange' 
1350 89C3              ****************************************************************
1351 89C3              *
1352 89C3              do_stateChange PROC Export 
1353 89C3              *
1354 89C3              * This message is sent when the state of the window that the control is
1355 89C3              * in has changed.
1356 89C3              *
1357 89C3              * Inputs:
1358 89C3              *                   none
1359 89C3              *
1360 89C3              * Outputs:
1361 89C3              *                   none
1362 89C3              *
1363 89C3              * External Refs:
1364 89C3              *                   none
1365 89C3              *
1366 89C3              * Entry Points:
1367 89C3              *                   none
1368 89C3              *
1369 89C3                       longa on                       ; mode
1370 89C3                       longi on 
1371 89C3              *
1372 89C3              ****************************************************************
1373 89C3
1374 89C3 A0 08 00              ldy   #PopUpCtlRecord.ctlRect
1375 89C6 20 3F 8D              jsr   PushPtrToRect2
1376 89C9 A2 0E 3A 22           _InvalRect 
1377 89D0
1378 89D0 AA                    tax   
1379 89D1
1380 89D1 60                    rts   
1381 89D2
1382 89D2                       ENDP 
1383 89D2
1384 89D2              ****************************************************************
1385 89D2              *
1386 89D2              GetPopUpDefProc PROC Export 
1387 89D2              *
1388 89D2              * Returns the address of the PopUp control def-proc.
1389 89D2              *
1390 89D2              *
1391 89D2              * Inputs:
1392 89D2              *                   space for pointer
1393 89D2              *
1394 89D2              * Outputs:
1395 89D2              *                   Pointer to DefProc
1396 89D2              *
1397 89D2              * External Refs:
1398 89D2                       import PopUpProc 
1399 89D2              *
1400 89D2              * Entry Points:
1401 89D2              *                   none
1402 89D2              *
1403 89D2                       longa on                       ; mode
1404 89D2                       longi on 
1405 89D2              *
1406 89D2              ****************************************************************
1407 89D2                       DefineStack 
1408 89D2              RTL1     block 3 
1409 89D2              RTL2     block 3 
1410 89D2              ThePointer LONG 
1411 89D2
1412 89D2 A9 47 85              lda   #PopUpProc
1413 89D5 83 07                 sta   ThePointer,s
1414 89D7 A9 FD 00              lda   #^PopUpProc
1415 89DA 83 09                 sta   ThePointer+2,s
1416 89DC
1417 89DC A9 00 00              lda   #0
1418 89DF 18                    clc   
1419 89E0 6B                    rtl   
1420 89E1
1421 89E1                       ENDP 
1422 89E1
1423 89E1              ********************************************************************************
1424 89E1              *
1425 89E1              *                   DerefMenuHand
1426 89E1              *
1427 89E1              * Dereference the menu handle in PopUpCtlRecord.MenuRef and put ptr in our direct
1428 89E1              * page space Temp.
1429 89E1              *
1430 89E1              ********************************************************************************
1431 89E1              derefMenuHand PROC 
1432 89E1
1433 89E1 A0 28 00              ldy   #PopUpCtlRecord.MenuRef
1434 89E4 B7 05                 lda   [<ctlPtr],y
1435 89E6 85 01                 sta   <temp
1436 89E8 C8                    iny   
1437 89E9 C8                    iny   
1438 89EA B7 05                 lda   [<ctlPtr],y
1439 89EC 85 03                 sta   <temp+2
1440 89EE
1441 89EE A7 01                 lda   [<temp]
1442 89F0 AA                    tax   
1443 89F1 A0 02 00              ldy   #2
1444 89F4 B7 01                 lda   [<temp],y
1445 89F6 85 03                 sta   <temp+2
1446 89F8 86 01                 stx   <temp
1447 89FA
1448 89FA 60                    rts   
1449 89FB
1450 89FB                       ENDP 
1451 89FB
1452 89FB              ********************************************************************************
1453 89FB              *
1454 89FB              *                   SetupColorTable
1455 89FB              *
1456 89FB              *                   This routine puts the pointer to the pop-up control's
1457 89FB              *                   color table into our direct page space <word1. If the
1458 89FB              *                   ctlColor field of the record is zero then we use the
1459 89FB              *                   default color table defined in PopUpData.
1460 89FB              *
1461 89FB              *  IN: <ctlPtr = ptr to pop-up's control record
1462 89FB              * OUT: <word1 = ptr to pop-up's color table (if ctlColor field is zero
1463 89FB              *               then we use the default color table)
1464 89FB              *
1465 89FB              ********************************************************************************
1466 89FB              SetupColorTable PROC 
1467 89FB
1468 89FB A0 26 00              ldy   #PopUpCtlRecord.ctlColor+2 ; get pop-up's color table
1469 89FE B7 05                 lda   [<ctlPtr],y              ; if this field is zero then it means we use
1470 8A00 88                    dey                            ; the default color table
1471 8A01 88                    dey   
1472 8A02 17 05                 ora   [<ctlPtr],y
1473 8A04 F0 41                 beq   @DefaultColor            ; use default color table
1474 8A06
1475 8A06 A0 24 00              ldy   #PopUpCtlRecord.ctlColor
1476 8A09 B7 05                 lda   [<ctlPtr],y
1477 8A0B 85 11                 sta   <word1
1478 8A0D C8                    iny   
1479 8A0E C8                    iny   
1480 8A0F B7 05                 lda   [<ctlPtr],y
1481 8A11 85 13                 sta   <word1+2
1482 8A13
1483 8A13 A0 3C 00              ldy   #PopUpCtlRecord.ctlmoreflags
1484 8A16 B7 05                 lda   [<ctlPtr],y
1485 8A18 29 18 00              and   #$0018                   ; bits 3 and 4 tell us what the color table is made of
1486 8A1B F0 34                 beq   @Done
1487 8A1D
1488 8A1D 89 08 00              bit   #$0008                   ; Is color table a handle?
1489 8A20 D0 18                 bne   @ColorTableIsHandle
1490 8A22
1491 8A22              @ColorTableIsResource  
1492 8A22 48                    pha   
1493 8A23 48                    pha   
1494 8A24 F4 0D 80              PushWord #rCtlColorTable 
1495 8A27 A5 13                 lda   <word1+2
1496 8A29 48                    pha   
1497 8A2A A5 11                 lda   <word1
1498 8A2C 48                    pha   
1499 8A2D A2 10 32 22           _CMLoadResource 
1500 8A34 68                    pla   
1501 8A35 85 11                 sta   <word1
1502 8A37 68                    pla   
1503 8A38 85 13                 sta   <word1+2
1504 8A3A
1505 8A3A              @ColorTableIsHandle  
1506 8A3A A0 02 00              ldy   #2
1507 8A3D B7 11                 lda   [<word1],y
1508 8A3F AA                    tax   
1509 8A40 A7 11                 lda   [<word1]
1510 8A42 85 11                 sta   <word1
1511 8A44 86 13                 stx   <word1+2
1512 8A46
1513 8A46 60                    rts   
1514 8A47
1515 8A47 A9 5E 8F     @DefaultColor lda   #DefColorTable
1516 8A4A 85 11                 sta   <word1
1517 8A4C A9 FD 00              lda   #^DefColorTable
1518 8A4F 85 13                 sta   <word1+2
1519 8A51
1520 8A51 60           @Done    rts   
1521 8A52
1522 8A52                       ENDP 
1523 8A52
1524 8A52              ********************************************************************************
1525 8A52              *
1526 8A52              *                   DrawResult
1527 8A52              *
1528 8A52              *                   This routine draws the currently selected menu item in
1529 8A52              *                   the pop-up rect. It first checks whether the FDontDrawResult
1530 8A52              *                   bit is set before doing anything. If the item ID in ctlValue
1531 8A52              *                   is invalid (carry set coming back from GetMItem) then we clear
1532 8A52              *                   whatever is currently in the pop-up rect and set ctlValue to zero.
1533 8A52              *
1534 8A52              *  IN: <word1 : contains ptr to pop-up's color table (call SetupColorTable)
1535 8A52              *      pop-up control's record is the current menu bar (call SetNewMenuBar)
1536 8A52              *      x-reg : $0000 = don't need to setup popup rect in <RECT (already done by DrawPopupBox)
1537 8A52              *              $FFFF = we need to setup <RECT still
1538 8A52              *
1539 8A52              ********************************************************************************
1540 8A52              DrawResult PROC 
1541 8A52                       import CheckForIcon 
1542 8A52
1543 8A52              ItemNameHdl equ   word3
1544 8A52              ItemNamePtr equ   word5
1545 8A52              mode     equ   word7
1546 8A52
1547 8A52 A0 10 00              ldy   #PopUpCtlRecord.ctlFlag  ; first check if result should be drawn
1548 8A55 B7 05                 lda   [<ctlPtr],y
1549 8A57 29 08 00              and   #FDontDrawResult
1550 8A5A F0 03                 beq   okToDraw
1551 8A5C 82 AE 01              brl   out
1552 8A5F
1553 8A5F 8A           okToDraw txa                            ; flag that tells us whether we're just drawing result
1554 8A60 10 03                 bpl   SkipThisSetup
1555 8A62
1556 8A62 20 8E 8C              jsr   ClearResult
1557 8A65
1558 8A65 48           SkipThisSetup pha                       ; space for result
1559 8A66 48                    pha   
1560 8A67 A0 12 00              ldy   #PopUpCtlRecord.ctlValue ; get pointer to currently selected item in pop-up menu
1561 8A6A B7 05                 lda   [<ctlPtr],y
1562 8A6C F0 0A                 beq   @Invalid                 ; if ctlValue is zero, its means nothing currently selected
1563 8A6E 48                    pha                            ; must special case zero because zero item id to GetMItem
1564 8A6F A2 0F 25 22           _GetMItem                      ; means get first item in menu!!!
1565 8A76 90 05                 bcc   @skipit                  ; item found
1566 8A78 68           @Invalid pla                            ; clean up stack first
1567 8A79 68                    pla   
1568 8A7A 82 91 01              brl   Errout
1569 8A7D
1570 8A7D 68           @skipit  pla   
1571 8A7E 85 19                 sta   <itemNamePtr
1572 8A80 68                    pla   
1573 8A81 85 1B                 sta   <itemNamePtr+2
1574 8A83
1575 8A83 64 15                 stz   <ItemNameHdl
1576 8A85 64 17                 stz   <ItemNameHdl+2
1577 8A87
1578 8A87 F4 00 00              pea   0
1579 8A8A A0 12 00              ldy   #PopUpCtlRecord.ctlValue
1580 8A8D B7 05                 lda   [<ctlPtr],y
1581 8A8F 48                    pha   
1582 8A90 A2 0F 27 22           _GetMItemFlag 
1583 8A97 68                    pla   
1584 8A98 29 00 C0              and   #$C000                   ; mask off high two bits of item flag to get ref
1585 8A9B F0 38                 beq   pointer                  ; 00 = ptr
1586 8A9D 10 16                 bpl   handle                   ; 01 = handle
1587 8A9F
1588 8A9F 48                    pha                            ; 10 = resource
1589 8AA0 48                    pha   
1590 8AA1 F4 06 80              pea   $8006                    ; string resource
1591 8AA4 D4 1B                 pei   <ItemNamePtr+2
1592 8AA6 D4 19                 pei   <ItemNamePtr
1593 8AA8 A2 10 32 22           _CMLoadResource 
1594 8AAF 68                    pla   
1595 8AB0 85 19                 sta   <ItemNamePtr
1596 8AB2 68                    pla   
1597 8AB3 85 1B                 sta   <ItemNamePtr+2
1598 8AB5
1599 8AB5 A5 19        handle   lda   <ItemNamePtr
1600 8AB7 85 15                 sta   <ItemNameHdl
1601 8AB9 A5 1B                 lda   <ItemNamePtr+2
1602 8ABB 85 17                 sta   <ItemNameHdl+2
1603 8ABD A0 04 00              ldy   #4                       ; first lock down handle
1604 8AC0 B7 15                 lda   [<ItemNameHdl],y
1605 8AC2 09 00 80              ora   #$8000
1606 8AC5 97 15                 sta   [<ItemNameHdl],y
1607 8AC7 A0 02 00              ldy   #2                       ; deref the handle
1608 8ACA B7 15                 lda   [<ItemNameHdl],y
1609 8ACC 85 1B                 sta   <ItemNamePtr+2
1610 8ACE A7 15                 lda   [<ItemNameHdl]
1611 8AD0 85 19                 sta   <ItemNamePtr
1612 8AD2
1613 8AD2 20 FB 89              jsr   SetupColorTable          ; reset ptr to color table just in case memory moved
1614 8AD5                                                      ; from above load resource
1615 8AD5              pointer   
1616 8AD5 20 33 8D              jsr   PushPtrToRect            ; inset the rect to get it ready for drawing the result
1617 8AD8 F4 02 00              pea   2
1618 8ADB F4 01 00              pea   1
1619 8ADE A2 04 4C 22           _InsetRect 
1620 8AE5
1621 8AE5 48                    pha                            ; get foreground color and save on the stack
1622 8AE6 A2 04 A1 22           _GetForeColor 
1623 8AED
1624 8AED 48                    pha   
1625 8AEE A2 04 9B 22           _GetTextFace                   ; save original text face
1626 8AF5
1627 8AF5 48                    pha   
1628 8AF6 A2 04 9D 22           _GetTextMode                   ; save original text mode
1629 8AFD
1630 8AFD F4 04 00              pea   4                        ; Transfer foreground pixels only
1631 8B00 A2 04 9C 22           _SetTextMode 
1632 8B07
1633 8B07 48                    pha                            ; clip title to the pop-up rectangle
1634 8B08 48                    pha   
1635 8B09 A2 04 C7 22           _GetClipHandle 
1636 8B10
1637 8B10 48                    pha                            ; get a new clip region
1638 8B11 48                    pha   
1639 8B12 A2 04 67 22           _NewRgn 
1640 8B19 A3 03                 lda   3,s
1641 8B1B 48                    pha   
1642 8B1C A3 03                 lda   3,s
1643 8B1E 48                    pha   
1644 8B1F A2 04 C6 22           _SetClipHandle 
1645 8B26
1646 8B26 20 33 8D              jsr   PushPtrToRect
1647 8B29 A2 04 26 22           _ClipRect 
1648 8B30
1649 8B30 20 33 8D              jsr   PushPtrToRect            ; put rect back the way it was before
1650 8B33 F4 FE FF              pea   $FFFE
1651 8B36 F4 FF FF              pea   $FFFF
1652 8B39 A2 04 4C 22           _InsetRect 
1653 8B40
1654 8B40 A7 11                 lda   [<word1]
1655 8B42 29 0F 00              and   #$000F
1656 8B45 48                    pha   
1657 8B46 0A                    asl   a
1658 8B47 0A                    asl   a
1659 8B48 0A                    asl   a
1660 8B49 0A                    asl   a
1661 8B4A 03 01                 ora   1,s
1662 8B4C 83 01                 sta   1,s
1663 8B4E EB                    xba   
1664 8B4F 03 01                 ora   1,s
1665 8B51 83 01                 sta   1,s
1666 8B53 A2 04 A0 22           _SetForeColor                  ; set the color of the text
1667 8B5A
1668 8B5A 48                    pha                            ; space for result
1669 8B5B A0 12 00              ldy   #PopUpCtlRecord.ctlValue
1670 8B5E B7 05                 lda   [<ctlPtr],y
1671 8B60 48                    pha   
1672 8B61 A2 0F 36 22           _GetMItemStyle 
1673 8B68 A2 04 9A 22           _SetTextFace 
1674 8B6F
1675 8B6F 48                    pha                            ; leading
1676 8B70 48                    pha                            ; widmax
1677 8B71 48                    pha                            ; descent
1678 8B72 48                    pha                            ; ascent
1679 8B73 3B                    tsc   
1680 8B74 1A                    inc   a
1681 8B75 F4 00 00              pea   0
1682 8B78 48                    pha   
1683 8B79 A2 04 96 22           _GetFontInfo 
1684 8B80 7A                    ply                            ; get ascent off stack
1685 8B81 68                    pla                            ; get descent off stack
1686 8B82 7A                    ply                            ; get widmax off stack
1687 8B83 7A                    ply                            ; get leading off stack
1688 8B84
1689 8B84 18                    clc   
1690 8B85 69 02 00              adc   #2
1691 8B88 48                    pha   
1692 8B89
1693 8B89 A0 10 00              ldy   #PopUpCtlRecord.ctlFlag
1694 8B8C B7 05                 lda   [<ctlPtr],y
1695 8B8E 29 01 00              and   #FRightJustifyResult
1696 8B91 F0 16                 beq   LeftJustifyResult
1697 8B93
1698 8B93 48                    pha                            ; space for result
1699 8B94 D4 1B                 pei   <ItemNamePtr+2
1700 8B96 D4 19                 pei   <ItemNamePtr
1701 8B98 A2 04 A9 22           _StringWidth 
1702 8B9F A5 0F                 lda   <Rect+x2
1703 8BA1 38                    sec   
1704 8BA2 E3 01                 sbc   1,s
1705 8BA4 E9 03 00              sbc   #3
1706 8BA7 80 13                 bra   storeLeft
1707 8BA9              LeftJustifyResult  
1708 8BA9 48                    pha                            ; calculate amount of space to indent result
1709 8BAA F4 57 00              pea   $57
1710 8BAD A2 04 A8 22           _CharWidth 
1711 8BB4 A3 01                 lda   1,s
1712 8BB6 6A                    ror   a
1713 8BB7 18                    clc   
1714 8BB8 63 01                 adc   1,s
1715 8BBA 65 0B                 adc   <Rect+x1
1716 8BBC AA           storeLeft tax   
1717 8BBD 68                    pla   
1718 8BBE
1719 8BBE A5 0D                 lda   <Rect+y2
1720 8BC0 38                    sec   
1721 8BC1 E3 01                 sbc   1,s
1722 8BC3 7A                    ply   
1723 8BC4 DA                    phx   
1724 8BC5 48                    pha   
1725 8BC6 A2 04 3A 22           _MoveTo 
1726 8BCD
1727 8BCD A5 1B                 lda   <ItemNamePtr+2
1728 8BCF 48                    pha   
1729 8BD0 A5 19                 lda   <ItemNamePtr
1730 8BD2 48                    pha   
1731 8BD3 A2 04 A5 22           _DrawString 
1732 8BDA
1733 8BDA A5 15                 lda   <ItemNameHdl
1734 8BDC 05 17                 ora   <ItemNameHdl+2
1735 8BDE F0 0A                 beq   NoHandle
1736 8BE0
1737 8BE0 A0 04 00              ldy   #4                       ; unlock handle to the title
1738 8BE3 B7 15                 lda   [<ItemNameHdl],y
1739 8BE5 29 FF 7F              and   #$7FFF
1740 8BE8 97 15                 sta   [<ItemNameHdl],y
1741 8BEA
1742 8BEA A2 04 68 22  NoHandle _DisposeRgn 
1743 8BF1 A2 04 C6 22           _SetClipHandle 
1744 8BF8
1745 8BF8 A2 04 9C 22           _SetTextMode                   ; restore original stuff
1746 8BFF A2 04 9A 22           _SetTextFace 
1747 8C06 A2 04 A0 22           _SetForeColor                  ; restore original foreground color
1748 8C0D
1749 8C0D 60           out      rts   
1750 8C0E
1751 8C0E A0 12 00     Errout   ldy   #PopUpCtlRecord.ctlValue
1752 8C11 A9 00 00              lda   #0                       ; zero ctlValue, this tells us there is no current selection
1753 8C14 97 05                 sta   [<ctlPtr],y
1754 8C16
1755 8C16 60                    rts   
1756 8C17
1757 8C17                       ENDP 
1758 8C17
1759 8C17              ********************************************************************************
1760 8C17              *
1761 8C17              *                   DrawPopUpBox
1762 8C17              *
1763 8C17              *                   Draws the pop-up rect and the drop shadow.
1764 8C17              *
1765 8C17              *  IN: <word1 : contains ptr to color table for pop-up
1766 8C17              *      <word7 : contains flag to tell us what mode we're in
1767 8C17              *
1768 8C17              ********************************************************************************
1769 8C17              DrawPopUpBox PROC 
1770 8C17
1771 8C17              mode     equ   word7
1772 8C17
1773 8C17 20 8E 8C              jsr   ClearResult              ; setup <RECT and fill background color of pop-up
1774 8C1A
1775 8C1A A2 01 00              ldx   #1                       ; set the pen size
1776 8C1D A5 1D                 lda   <mode
1777 8C1F F0 01                 beq   Not640
1778 8C21 E8                    inx   
1779 8C22 DA           Not640   phx                            ; width of pen
1780 8C23 F4 01 00              pea   1                        ; height of pen
1781 8C26 A2 04 2C 22           _SetPenSize 
1782 8C2D
1783 8C2D F4 FD 00              pea   color_patt>>16           ; make sure pen pattern is setup according to
1784 8C30 A0 04 00              ldy   #4                       ; pop-up menu's color table
1785 8C33 B7 11                 lda   [<word1],y
1786 8C35 29 F0 00              and   #$00F0
1787 8C38 0A                    asl   a
1788 8C39 69 4E 8D              adc   #color_patt
1789 8C3C 48                    pha   
1790 8C3D A2 04 30 22           _SetPenPat 
1791 8C44
1792 8C44 20 33 8D              jsr   PushPtrToRect            ; now frame it
1793 8C47 A2 04 53 22           _FrameRect 
1794 8C4E
1795 8C4E              ;
1796 8C4E              ; --- Draw the drop shadow for the pop-up rect ---------------------------------------
1797 8C4E              ;
1798 8C4E A4 0F                 ldy   <Rect+x2                 ; Pass last point
1799 8C50 5A                    phy   
1800 8C51 A5 09                 lda   <Rect+y1
1801 8C53 18                    clc   
1802 8C54 69 04 00              adc   #4
1803 8C57 48                    pha   
1804 8C58
1805 8C58 5A                    phy                            ; Pass second point
1806 8C59 A6 0D                 ldx   <Rect+y2
1807 8C5B DA                    phx   
1808 8C5C
1809 8C5C A5 0B                 lda   <Rect+x1                 ; Set starting point
1810 8C5E 18                    clc   
1811 8C5F 69 05 00              adc   #5
1812 8C62 48                    pha   
1813 8C63 DA                    phx   
1814 8C64 A2 04 3A 22           _MoveTo 
1815 8C6B A2 04 3C 22           _LineTo 
1816 8C72
1817 8C72 A9 01 00              lda   #1
1818 8C75 A6 1D                 ldx   <mode
1819 8C77 F0 01                 beq   In320mode
1820 8C79 1A                    inc   a
1821 8C7A 0A           In320mode asl   a
1822 8C7B 48                    pha   
1823 8C7C F4 01 00              pea   1
1824 8C7F A2 04 2C 22           _SetPenSize 
1825 8C86 A2 04 3C 22           _LineTo 
1826 8C8D
1827 8C8D 60                    rts   
1828 8C8E
1829 8C8E                       ENDP 
1830 8C8E
1831 8C8E              ********************************************************************************
1832 8C8E              *
1833 8C8E              *                   ClearResult
1834 8C8E              *
1835 8C8E              *                   This routine clears the item in the pop-up rect
1836 8C8E              *                   it also puts the popup rect in <RECT.
1837 8C8E              *
1838 8C8E              *  IN: <ctlPtr : ptr to pop-up control record
1839 8C8E              *      <word1 : contains ptr to pop-up control's color table
1840 8C8E              * OUT: <RECT contains the pop-up rect (not including right drop shadow)
1841 8C8E              *
1842 8C8E              ********************************************************************************
1843 8C8E              ClearResult PROC 
1844 8C8E
1845 8C8E 48                    pha   
1846 8C8F A2 04 17 22           _GetMasterSCB 
1847 8C96 68                    pla   
1848 8C97 29 80 00              and   #$0080
1849 8C9A 85 1D                 sta   <word7
1850 8C9C
1851 8C9C A0 30 00              ldy   #PopUpCtlRecord.PopUpRect
1852 8C9F 20 11 8D              jsr   MoveRect
1853 8CA2
1854 8CA2 A4 0F                 ldy   <Rect+x2
1855 8CA4 88                    dey   
1856 8CA5 88                    dey   
1857 8CA6 A5 1D                 lda   <word7
1858 8CA8 F0 02                 beq   Its320
1859 8CAA 88                    dey   
1860 8CAB 88                    dey   
1861 8CAC 84 0F        Its320   sty   <Rect+x2
1862 8CAE
1863 8CAE C6 0D                 dec   <Rect+y2                 ; adjust for bottom drop shadow
1864 8CB0
1865 8CB0 20 33 8D              jsr   PushPtrToRect
1866 8CB3 A2 01 00              ldx   #1
1867 8CB6 A5 1D                 lda   <word7
1868 8CB8 F0 01                 beq   pushit1
1869 8CBA E8                    inx   
1870 8CBB DA           pushit1  phx   
1871 8CBC F4 01 00              pea   1
1872 8CBF A2 04 4C 22           _InsetRect 
1873 8CC6
1874 8CC6 20 33 8D              jsr   PushPtrToRect            ; no valid current selection
1875 8CC9 F4 FD 00              pea   color_patt>>16
1876 8CCC A7 11                 lda   [<word1]
1877 8CCE 29 F0 00              and   #$00F0
1878 8CD1 0A                    asl   a
1879 8CD2 69 4E 8D              adc   #color_patt
1880 8CD5 48                    pha   
1881 8CD6 A2 04 57 22           _FillRect 
1882 8CDD
1883 8CDD 20 33 8D              jsr   PushPtrToRect
1884 8CE0 A2 FF FF              ldx   #$FFFF
1885 8CE3 A5 1D                 lda   <word7
1886 8CE5 F0 01                 beq   pushit2
1887 8CE7 CA                    dex   
1888 8CE8 DA           pushit2  phx   
1889 8CE9 F4 FF FF              pea   $FFFF
1890 8CEC A2 04 4C 22           _InsetRect 
1891 8CF3
1892 8CF3 60                    rts   
1893 8CF4
1894 8CF4                       ENDP 
1895 8CF4
1896 8CF4              ********************************************************************************
1897 8CF4              *
1898 8CF4              *                   SetNewMenuBar
1899 8CF4              *
1900 8CF4              * Saves the handle to the old menu bar on the stack and then sets the new menu bar
1901 8CF4              * to that of the control handle.
1902 8CF4              *
1903 8CF4              ********************************************************************************
1904 8CF4              setNewMenuBar PROC 
1905 8CF4
1906 8CF4 68                    pla                            ; get rts off the stack
1907 8CF5 85 11                 sta   <word1
1908 8CF7
1909 8CF7 48                    pha                            ; save original menubar on the stack
1910 8CF8 48                    pha   
1911 8CF9 A2 0F 0A 22           _GetMenuBar 
1912 8D00
1913 8D00 A5 27                 lda   <theCtlHandle+2          ; make the new menu bar the popup control
1914 8D02 48                    pha   
1915 8D03 A5 25                 lda   <theCtlHandle
1916 8D05 48                    pha   
1917 8D06 A2 0F 39 22           _SetMenuBar 
1918 8D0D
1919 8D0D A5 11                 lda   <word1
1920 8D0F 48                    pha   
1921 8D10
1922 8D10 60                    rts   
1923 8D11
1924 8D11                       ENDP 
1925 8D11
1926 8D11
1927 8D11              ********************************************************************************
1928 8D11              *
1929 8D11              * MoveRect
1930 8D11              *
1931 8D11              * Moves the rectangle from the control record
1932 8D11              * to direct page.
1933 8D11              *
1934 8D11              * The source rectangle is specified by placing
1935 8D11              * its offset in the y-reg.
1936 8D11              *
1937 8D11              ********************************************************************************
1938 8D11              MoveRect PROC 
1939 8D11
1940 8D11 A2 00 00              ldx   #0                       ; copy rect to d page
1941 8D14 B7 05        @1       lda   [CtlPtr],y
1942 8D16 95 09                 sta   rect,x
1943 8D18 C8                    iny   
1944 8D19 C8                    iny   
1945 8D1A E8                    inx   
1946 8D1B E8                    inx   
1947 8D1C E0 08 00              cpx   #8
1948 8D1F 90 F3                 bcc   @1
1949 8D21
1950 8D21 60                    rts   
1951 8D22
1952 8D22                       ENDP 
1953 8D22
1954 8D22
1955 8D22              ********************************************************************************
1956 8D22              *
1957 8D22              * MoveRectIn
1958 8D22              *
1959 8D22              * Moves the rectangle from direct page to the control record
1960 8D22              *
1961 8D22              * The destination rectangle is specified by placing
1962 8D22              * its offset in the y-reg.
1963 8D22              *
1964 8D22              ********************************************************************************
1965 8D22              MoveRectIn PROC 
1966 8D22
1967 8D22 A2 00 00              ldx   #0
1968 8D25 B5 09        @1       lda   Rect,x
1969 8D27 97 05                 sta   [CtlPtr],y
1970 8D29 C8                    iny   
1971 8D2A C8                    iny   
1972 8D2B E8                    inx   
1973 8D2C E8                    inx   
1974 8D2D E0 08 00              cpx   #8
1975 8D30 90 F3                 bcc   @1
1976 8D32
1977 8D32 60                    rts   
1978 8D33
1979 8D33                       ENDP 
1980 8D33
1981 8D33
1982 8D33              ********************************************************************************
1983 8D33              *
1984 8D33              * PushPtrToRect
1985 8D33              *
1986 8D33              * Pushes pointer to controls bounding rect.
1987 8D33              *
1988 8D33              ********************************************************************************
1989 8D33              PushPtrToRect PROC 
1990 8D33
1991 8D33 7A                    ply                            ; save rts
1992 8D34 F4 00 00              pea   0000
1993 8D37 7B                    tdc   
1994 8D38 18                    clc   
1995 8D39 69 09 00              adc   #Rect                    ; get address of rect on stack
1996 8D3C 48                    pha   
1997 8D3D
1998 8D3D 5A                    phy                            ; restore rts
1999 8D3E
2000 8D3E 60                    rts   
2001 8D3F
2002 8D3F                       ENDP 
2003 8D3F
2004 8D3F
2005 8D3F              ********************************************************************************
2006 8D3F              *
2007 8D3F              * PushPtrToRect2
2008 8D3F              *
2009 8D3F              * Y contains the offset of the pointer to the rectangle to push on the stack.
2010 8D3F              *
2011 8D3F              ********************************************************************************
2012 8D3F              PushPtrToRect2 PROC 
2013 8D3F
2014 8D3F FA                    plx                            ; save return address
2015 8D40
2016 8D40 98                    tya                            ; y contains the offset in control record of rect to push
2017 8D41 18                    clc   
2018 8D42 65 05                 adc   CtlPtr                   ; base address of control record
2019 8D44 A8                    tay   
2020 8D45 A5 07                 lda   CtlPtr+2                 ; high word of address
2021 8D47 69 00 00              adc   #0
2022 8D4A 48                    pha                            ; push address on the stack
2023 8D4B 5A                    phy   
2024 8D4C
2025 8D4C DA                    phx                            ; restore the return address
2026 8D4D
2027 8D4D 60                    rts   
2028 8D4E
2029 8D4E                       ENTRY color_patt
2030 8D4E              color_patt  
2031 8D4E 00 00 00 00           DC B:0,0,0,0,0,0,0,0
2032 8D56 00 00 00 00           DC B:0,0,0,0,0,0,0,0
2033 8D5E 00 00 00 00           DC B:0,0,0,0,0,0,0,0
2034 8D66 00 00 00 00           DC B:0,0,0,0,0,0,0,0
2035 8D6E 11 11 11 11           DC B:$11,$11,$11,$11,$11,$11,$11,$11
2036 8D76 11 11 11 11           DC B:$11,$11,$11,$11,$11,$11,$11,$11
2037 8D7E 11 11 11 11           DC B:$11,$11,$11,$11,$11,$11,$11,$11
2038 8D86 11 11 11 11           DC B:$11,$11,$11,$11,$11,$11,$11,$11
2039 8D8E 22 22 22 22           DC B:$22,$22,$22,$22,$22,$22,$22,$22
2040 8D96 22 22 22 22           DC B:$22,$22,$22,$22,$22,$22,$22,$22
2041 8D9E 22 22 22 22           DC B:$22,$22,$22,$22,$22,$22,$22,$22
2042 8DA6 22 22 22 22           DC B:$22,$22,$22,$22,$22,$22,$22,$22
2043 8DAE 33 33 33 33           DC B:$33,$33,$33,$33,$33,$33,$33,$33
2044 8DB6 33 33 33 33           DC B:$33,$33,$33,$33,$33,$33,$33,$33
2045 8DBE 33 33 33 33           DC B:$33,$33,$33,$33,$33,$33,$33,$33
2046 8DC6 33 33 33 33           DC B:$33,$33,$33,$33,$33,$33,$33,$33
2047 8DCE 44 44 44 44           DC B:$44,$44,$44,$44,$44,$44,$44,$44
2048 8DD6 44 44 44 44           DC B:$44,$44,$44,$44,$44,$44,$44,$44
2049 8DDE 44 44 44 44           DC B:$44,$44,$44,$44,$44,$44,$44,$44
2050 8DE6 44 44 44 44           DC B:$44,$44,$44,$44,$44,$44,$44,$44
2051 8DEE 55 55 55 55           DC B:$55,$55,$55,$55,$55,$55,$55,$55
2052 8DF6 55 55 55 55           DC B:$55,$55,$55,$55,$55,$55,$55,$55
2053 8DFE 55 55 55 55           DC B:$55,$55,$55,$55,$55,$55,$55,$55
2054 8E06 55 55 55 55           DC B:$55,$55,$55,$55,$55,$55,$55,$55
2055 8E0E 66 66 66 66           DC B:$66,$66,$66,$66,$66,$66,$66,$66
2056 8E16 66 66 66 66           DC B:$66,$66,$66,$66,$66,$66,$66,$66
2057 8E1E 66 66 66 66           DC B:$66,$66,$66,$66,$66,$66,$66,$66
2058 8E26 66 66 66 66           DC B:$66,$66,$66,$66,$66,$66,$66,$66
2059 8E2E 77 77 77 77           DC B:$77,$77,$77,$77,$77,$77,$77,$77
2060 8E36 77 77 77 77           DC B:$77,$77,$77,$77,$77,$77,$77,$77
2061 8E3E 77 77 77 77           DC B:$77,$77,$77,$77,$77,$77,$77,$77
2062 8E46 77 77 77 77           DC B:$77,$77,$77,$77,$77,$77,$77,$77
2063 8E4E 88 88 88 88           DC B:$88,$88,$88,$88,$88,$88,$88,$88
2064 8E56 88 88 88 88           DC B:$88,$88,$88,$88,$88,$88,$88,$88
2065 8E5E 88 88 88 88           DC B:$88,$88,$88,$88,$88,$88,$88,$88
2066 8E66 88 88 88 88           DC B:$88,$88,$88,$88,$88,$88,$88,$88
2067 8E6E 99 99 99 99           DC B:$99,$99,$99,$99,$99,$99,$99,$99
2068 8E76 99 99 99 99           DC B:$99,$99,$99,$99,$99,$99,$99,$99
2069 8E7E 99 99 99 99           DC B:$99,$99,$99,$99,$99,$99,$99,$99
2070 8E86 99 99 99 99           DC B:$99,$99,$99,$99,$99,$99,$99,$99
2071 8E8E AA AA AA AA           DC B:$AA,$AA,$AA,$AA,$AA,$AA,$AA,$AA
2072 8E96 AA AA AA AA           DC B:$AA,$AA,$AA,$AA,$AA,$AA,$AA,$AA
2073 8E9E AA AA AA AA           DC B:$AA,$AA,$AA,$AA,$AA,$AA,$AA,$AA
2074 8EA6 AA AA AA AA           DC B:$AA,$AA,$AA,$AA,$AA,$AA,$AA,$AA
2075 8EAE BB BB BB BB           DC B:$BB,$BB,$BB,$BB,$BB,$BB,$BB,$BB
2076 8EB6 BB BB BB BB           DC B:$BB,$BB,$BB,$BB,$BB,$BB,$BB,$BB
2077 8EBE BB BB BB BB           DC B:$BB,$BB,$BB,$BB,$BB,$BB,$BB,$BB
2078 8EC6 BB BB BB BB           DC B:$BB,$BB,$BB,$BB,$BB,$BB,$BB,$BB
2079 8ECE CC CC CC CC           DC B:$CC,$CC,$CC,$CC,$CC,$CC,$CC,$CC
2080 8ED6 CC CC CC CC           DC B:$CC,$CC,$CC,$CC,$CC,$CC,$CC,$CC
2081 8EDE CC CC CC CC           DC B:$CC,$CC,$CC,$CC,$CC,$CC,$CC,$CC
2082 8EE6 CC CC CC CC           DC B:$CC,$CC,$CC,$CC,$CC,$CC,$CC,$CC
2083 8EEE DD DD DD DD           DC B:$DD,$DD,$DD,$DD,$DD,$DD,$DD,$DD
2084 8EF6 DD DD DD DD           DC B:$DD,$DD,$DD,$DD,$DD,$DD,$DD,$DD
2085 8EFE DD DD DD DD           DC B:$DD,$DD,$DD,$DD,$DD,$DD,$DD,$DD
2086 8F06 DD DD DD DD           DC B:$DD,$DD,$DD,$DD,$DD,$DD,$DD,$DD
2087 8F0E EE EE EE EE           DC B:$EE,$EE,$EE,$EE,$EE,$EE,$EE,$EE
2088 8F16 EE EE EE EE           DC B:$EE,$EE,$EE,$EE,$EE,$EE,$EE,$EE
2089 8F1E EE EE EE EE           DC B:$EE,$EE,$EE,$EE,$EE,$EE,$EE,$EE
2090 8F26 EE EE EE EE           DC B:$EE,$EE,$EE,$EE,$EE,$EE,$EE,$EE
2091 8F2E FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
2092 8F36 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
2093 8F3E FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
2094 8F46 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
2095 8F4E
2096 8F4E                       ENDP 
2097 8F4E
2098 8F4E
2099 8F4E              ********************************************************************************
2100 8F4E              PopUpData PROC 
2101 8F4E
2102 8F4E              ; --- Masks for dimmed and normal text -----------------------------
2103 8F4E
2104 8F4E                       ENTRY dimmed 
2105 8F4E              dimmed   DC.B $55,$AA,$55,$AA,$55,$AA,$55,$AA 
2106 8F4E                       ENTRY nor_mask 
2107 8F4E              nor_mask DC.B $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF 
2108 8F4E
2109 8F4E              ; --- Default menu bar color table ---------------------------
2110 8F4E              ;
2111 8F4E                       ENTRY DefColorTable 
2112 8F4E 55 AA        DefColorTable DC W:$00F0                Normal color, black text on white.
2113 8F50 55 AA                 DC W:$000F                     Hilited color, white text on black.
2114 8F52 55 AA                 DC W:$0000                     Outline color, black.
2115 8F54
2116 8F54                       ENDP 
2117 8F54
2118 8F54                       END   
